<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\AdvertisementsRequest;
use App\Http\Resources\AdvertisementsResource;
use App\Models\Advertisement;
use Illuminate\Http\Request;

class AdvertisementsController extends Controller
{
    public function index(){
        $Advertisement=Advertisement::all();
        if($Advertisement->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Advertisement
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function store(AdvertisementsRequest $request){
       
        $Advertisement=Advertisement::create([
            'center_name'=>$request->center_name,
            'center_image'=>$request->center_image,
            'user_id'=>$request->user_id,
            'status'=>$request->status,
          ]);
        return new AdvertisementsResource($Advertisement);
    }
    public function show($id){
        $Advertisement=Advertisement::findOrFail($id);
        if($Advertisement){
            return response()->json([
                'status'=>200,
                'group'=>$Advertisement
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function update(AdvertisementsRequest $request,$id){
        $Advertisement = Advertisement::find($id);
        $Advertisement->update($request->all());
        return new AdvertisementsResource($Advertisement);
    }
    public function delete($id){
        $Advertisement=Advertisement::find($id);
        $Advertisement->delete();
        if($Advertisement){
            return response()->json([
                'status'=>200,
                'message'=>'Deleted'
            ],200);
        }
    }
    public function search($name){
        $Advertisement=Advertisement::where('center_name','Like','%'.$name.'%')->get();
        if($Advertisement->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Advertisement
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
}
