<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\ClassRequest;
use App\Http\Resources\ClassResource;
use App\Models\Group;
use App\Models\Season;

class ClassController extends Controller
{
    public function index(){
        $Season=Season::all();
        if($Season->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Season
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function store(ClassRequest $request){
       
        $Season=Season::create([
                'name'=>$request->name,
                'user_id'=>$request->user_id
                ]);
        return new ClassResource($Season);
    }
    public function show($id){
        $Season=Season::findOrFail($id);
        if($Season){
            return response()->json([
                'status'=>200,
                'group'=>$Season
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function update(ClassRequest $request,$id){
        $Season = Season::find($id);
        $Season->update($request->all());
        return new ClassResource($Season);
    }
    public function delete($id){
        $Season=Season::find($id);
        $Season->delete();
        if($Season){
            return response()->json([
                'status'=>200,
                'message'=>'Deleted'
            ],200);
        }
    }
    public function search($name){
        $Season=Season::where('name','Like','%'.$name.'%')->get();
        if($Season->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Season
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
}

