<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\ExamRequest;
use App\Http\Resources\ExamResource;
use App\Models\Exam;
use Illuminate\Http\Request;

class ExamController extends Controller
{
    public function index(){
        $Exam=Exam::all();
        if($Exam->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Exam
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function store(ExamRequest $request){
       
        $Exam=Exam::create([
            'season'=>$request->season,
            'subject'=>$request->subject,
            'date_start'=>$request->date_start,
            'user_id'=>$request->user_id,
            'group_id'=>$request->group_id,
            'status'=>$request->status,
          ]);
        return new ExamResource($Exam);
    }
    public function show($id){
        $Exam=Exam::findOrFail($id);
        if($Exam){
            return response()->json([
                'status'=>200,
                'group'=>$Exam
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function update(ExamRequest $request,$id){
        $Exam = Exam::find($id);
        $Exam->update($request->all());
        return new ExamResource($Exam);
    }
    public function delete($id){
        $Exam=Exam::find($id);
        $Exam->delete();
        if($Exam){
            return response()->json([
                'status'=>200,
                'message'=>'Deleted'
            ],200);
        }
    }
    public function search($name){
        $Exam=Exam::where('season','Like','%'.$name.'%')->get();
        if($Exam->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Exam
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
}
