<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\LessonsRequest;
use App\Http\Resources\LessonsResource;
use App\Models\Lesson;
use App\Models\Lessons_attendance;
use App\Models\User;
use Illuminate\Http\Request;

class LessonsController extends Controller
{
    public function index(){
        $lessons = Lesson::all();

        return response()->json([
            'status'=>200,
            'data'=> $lessons->count() > 0 ? $lessons : 'No lessons found'
        ],200);

    }

    public function store(LessonsRequest $request){

        $lesson = Lesson::create($request->all());

        return new LessonsResource($lesson);
    }

    public function show($id){
        $lesson = Lesson::findOrFail($id);

        return response()->json([
            'status'=>200,
            'data'=> $lesson ?? 'No lessons found'
        ],200);

    }

    public function update(LessonsRequest $request){
        $lesson = Lesson::find($request->id);

        $lesson->update($request->all());
        return new LessonsResource($lesson);
    }

    public function destroy(Request $request){

        $lesson = Lesson::where('id', $request->id)->delete();

            return response()->json([
                'status'=>200,
                'message'=>$lesson ? 'Lesson deleted successfully' : 'No lessons found'
            ],200);

    }

    public function attendance_num(Request $request){

        $user = User::where('code', $request->user_code)->first();
        $lesson = Lesson::where('id', $request->lesson_id)->first();

        if (isset($user) && isset($lesson)){
            $attendance = Lessons_attendance::create([
               'lesson_id' => $lesson->id,
               'user_id' => $user->id
            ]);
        }

            return response()->json([
                'status'=>200,
                'message'=>isset($attendance) ? 'User attended successfully' : 'No lessons or users found'
            ],200);

    }

    public function attendance_qr($id){

        $user = auth()->user();
        $lesson = Lesson::where('id', $id)->first();

        if (isset($user) && isset($lesson)){
            $attendance = Lessons_attendance::create([
               'lesson_id' => $lesson->id,
               'user_id' => $user->id
            ]);
        }

            return response()->json([
                'status'=>200,
                'message'=>isset($attendance) ? 'User attended successfully' : 'No lessons or users found'
            ],200);

    }


}
