<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Helpers\Helper;
use App\Http\Requests\LoginRequest;
use App\Http\Resources\UserResource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{//validate login user send response

    public function login(LoginRequest $request){
       if(!Auth::attempt($request->only('email','password'))){
        Helper::sendError('email or password is wrong!!!');
       }
       return new UserResource(auth()->user());
    }
}
