<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Helpers\Helper;
use App\Http\Requests\RegisterRequest;
use App\Http\Resources\UserResource;
use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Str;

class RegisterController extends Controller
{//validate register user send response

    public function register(RegisterRequest $request){
        $user=User::create([
            'name'=>$request->name,
            'email'=>$request->email,
            'password'=>bcrypt($request->password),
            'code'=> Str::random(4),
        ]);
        $user_role=Role::where(['name'=>$request->role])->first();
        if($user_role){
            $user->assignRole($user_role);
        }

       return new UserResource($user);
    }
}

