<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\SubjectRequest;
use App\Http\Resources\SubjectResource;
use App\Models\Subject;
use Illuminate\Http\Request;

class SubjectController extends Controller
{
    public function index (){
        $subject=Subject::all();
        if($subject->count() > 0){
            return response()->json([
                'status'=>200,
                'subject'=>$subject
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function store(SubjectRequest $request){

        $Subject=Subject::create([
            'name'=>$request->name,
          ]);
        return new SubjectResource($Subject);
    }
    public function show($id){
        $Subject=Subject::findOrFail($id);
        if($Subject){
            return response()->json([
                'status'=>200,
                'group'=>$Subject
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function update(SubjectRequest $request,$id){
        $Subject = Subject::find($id);
        $Subject->update($request->all());
        return new SubjectResource($Subject);
    }
    public function delete($id){
        $Subject=Subject::find($id);
        $Subject->delete();
        if($Subject){
            return response()->json([
                'status'=>200,
                'message'=>'Deleted'
            ],200);
        }
    }
    public function search($name){
        $Subject=Subject::where('name','Like','%'.$name.'%')->get();
        if($Subject->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Subject
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
}
