<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    
    public function up(): void
    {
        Schema::create('exams_answers', function (Blueprint $table) {
            $table->id();
            $table->integer('question_id');
            $table->string('name');

            $table->unsignedBigInteger('exam_questions_id');
            $table->foreign('exam_questions_id')->references('id')->on('exams_questions')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams_answers');
    }
};
