<?php

use App\Http\Controllers\Api\{AdvertisementsController,
    ClassController,
    ExamController,
    GroupController,
    LessonsController,
    LoginController,
    quizezController,
    RegisterController,
    SubjectController};
use App\Http\Resources\UserResource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return new UserResource($request->user());
});


Route::middleware('auth:sanctum')->group( function  (){
    // Lessons Route start
    Route::resource('/lessons',LessonsController::class);
    Route::post('/attendance_num',[LessonsController::class,'attendance_num']);
    Route::get('/attendance_qr/{id}',[LessonsController::class,'attendance_qr']);
// Lessons Route End

// Group Route start
    Route::get('/group',[GroupController::class,'index']);
    Route::post('/group',[GroupController::class,'store']);
    Route::get('/group/{id}',[GroupController::class,'show']);
    Route::put('/group/{id}',[GroupController::class,'update']);
    Route::delete('/group/{id}',[GroupController::class,'delete']);
    Route::get('/group/search/{name}',[GroupController::class,'search']);
    Route::post('/group_user',[GroupController::class,'group_user']);
// Group Route End
// Exam Route start
    Route::get('/exam',[ExamController::class,'index']);
    Route::post('/exam',[ExamController::class,'store']);
    Route::get('/exam/{id}',[ExamController::class,'show']);
    Route::put('/exam/{id}',[ExamController::class,'update']);
    Route::delete('/exam/{id}',[ExamController::class,'delete']);
    Route::get('/exam/search/{name}',[ExamController::class,'search']);
// Exam Route End
// advertisement Route start
    Route::get('/advertisement',[AdvertisementsController::class,'index']);
    Route::post('/advertisement',[AdvertisementsController::class,'store']);
    Route::get('/advertisement/{id}',[AdvertisementsController::class,'show']);
    Route::put('/advertisement/{id}',[AdvertisementsController::class,'update']);
    Route::delete('/advertisement/{id}',[AdvertisementsController::class,'delete']);
    Route::get('/advertisement/search/{name}',[AdvertisementsController::class,'search']);
// advertisement Route end
// Subject Route start
    Route::get('/subject',[SubjectController::class,'index']);
    Route::post('/subject',[SubjectController::class,'store']);
    Route::get('/subject/{id}',[SubjectController::class,'show']);
    Route::put('/subject/{id}',[SubjectController::class,'update']);
    Route::delete('/subject/{id}',[SubjectController::class,'delete']);
    Route::get('/subject/search/{name}',[SubjectController::class,'search']);
// Subject Route end
// class Route start
    Route::get('/class',[ClassController::class,'index']);
    Route::post('/class',[ClassController::class,'store']);
    Route::get('/class/{id}',[ClassController::class,'show']);
    Route::put('/class/{id}',[ClassController::class,'update']);
    Route::delete('/class/{id}',[ClassController::class,'delete']);
    Route::get('/class/search/{name}',[ClassController::class,'search']);
// class Route end
// Quizez Route start
    Route::get('/quizez',[quizezController::class,'index']);
    Route::post('/quizez',[quizezController::class,'store']);
    Route::get('/quizez/{id}',[quizezController::class,'show']);
    Route::put('/quizez/{id}',[quizezController::class,'update']);
    Route::delete('/quizez/{id}',[quizezController::class,'delete']);
    Route::get('/quizez/search/{name}',[quizezController::class,'search']);
// quizez Route end

});


// login And Register  Route start
Route::post('login',[LoginController::class,'login']);
Route::post('register',[RegisterController::class,'register']);
// login And Register  Route End
