<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\AdvertisementsRequest;
use App\Http\Resources\AdvertisementsResource;
use App\Models\Advertisement;
use App\Models\Group;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\Advertisement_group;


class AdvertisementsController extends Controller
{
    public function index(Request $request){
           $Advertisements=Group::where('id',$request->group_id)->with('ads')->first();
            return response()->json([
                'status'=>200,
                'advertisements'=>$Advertisements->ads
            ],200);
       
    }
    public function store(AdvertisementsRequest $request){
        if(!$request->hasFile('image')) {
            $filename = null;
        // return response()->json(['upload_file_not_found'], 400);
    }else{
    $file = $request->file('image');
    if(!$file->isValid()) {
        return response()->json(['invalid_file_upload'], 400);
    }
    $path = public_path() . '/uploads/ads/';
    $filename = uniqid() . '.'.$file->getClientOriginalName();

    $file->move($path,$filename);
    }

        $Advertisement=Advertisement::create([
            'name'=>$request->name,
            'content'=>$request->content,
            'user_id'=>$request->user_id,
            'image'=>'https://buddy.linkie.tech/public/uploads/ads/'.$filename,
            
            'status'=>$request->status,
            'start_date'=>$request->start_date,
            'end_date'=>$request->end_date,
          ]);
          $groups=[];
          foreach(json_decode($request->groups) as $group){
              
             Advertisement_group::create([
                 'group_id'=>$group,
                 'advertisement_id'=>$Advertisement->id
                 ]);
          }
          $ad = Advertisement::where('id',$Advertisement->id)->with('groups')->first
          ();
        return response()->json([
            'status'=>200,
            'data'=>['advertisement'=>$ad],
            'message'=>'Advertisement Created Successfully'
        ],200);
    }
    public function show($id){
        $Advertisement=Advertisement::findOrFail($id);
        if($Advertisement){
            return response()->json([
                'status'=>200,
                'group'=>$Advertisement
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function update(AdvertisementsRequest $request,$id){
        $Advertisement = Advertisement::find($id);
        $Advertisement->update($request->all());
        return response()->json([
            'status'=>200,
            'data'=>$Advertisement,
            'message'=>'Advertisement Updated Successfully'
        ],200);
    }
    public function delete(Request $request){
        $Advertisement=Advertisement::find($request->id);
        $Advertisement->delete();
        if($Advertisement){
            return response()->json([
                'status'=>200,
                'message'=>'Advertisement Deleted Successfully'
            ],200);
        }
    }
    public function search($name){
        $Advertisement=Advertisement::where('center_name','Like','%'.$name.'%')->get();
        if($Advertisement->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Advertisement
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    
     public function student_ads(Request $request){
          $time=Carbon::now();
          $Advertisements=Group::where('id',$request->group_id)->with('ads')->first();
            //   ->where('start_date','>',$time)->where('end_date','<',$time)->get();
            $ads=[];
         foreach($Advertisements->ads as $Advertisement){
             if($Advertisement->start_date > $time AND $Advertisement->end_date < $time){
                 $ads[]= $Advertisement;
             }
         }
            return response()->json([
                'status'=>200,
                'advertisements'=>$ads
            ],200);
   
    }
}
