<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\GroupRequest;
use App\Http\Resources\GroupResource;
use App\Models\Group;
use App\Models\Lessons_attendance;
use Illuminate\Http\Request;

// use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Validator;

class GroupController extends Controller
{
    public function index(){
        $group=Group::all();
        if($group->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$group
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'لا يوجد'
            ],404);
        }
    }
    
  
    public function store(GroupRequest $request){

        $group=Group::create([
            'name'=>$request->name,
            'grade_id'=>$request->grade_id,
            'user_id'=>$request->user_id,
            'center_id'=>$request->center_id,
            'subject_id'=>$request->subject_id,
            'year_id'=>$request->year_id,
            'role'=>$request->role
        ]);

        return response()->json([
            'status'=>200,
            'message' => 'تم الإضافة بنجاح',
            'data' => $group
        ],200);
    }
    public function show($id){

        $group = Group::with('users')->where('id', $id)->first();

        if($group){
            return response()->json([
                'status'=>200,
                'data'=>$group
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'لا يوجد'
            ],404);
        }
    }
    public function update(GroupRequest $request,$id){
        $group = Group::find($id);

        if ($group){
            $group->update($request->all());
        }

        return response()->json([
            'status'=> $group ? 200 : 404,
            'message' => $group ? 'تم التعديل بنجاح' : 'لا يوجد',
            'data' => $group ?? ''
        ],200);
    }
    public function delete(Request $request){
        $group = Group::find($request->id);
        if ($group){
            $group->delete();
        }

        return response()->json([
            'status'=> $group ? 200 : 404,
            'message' => $group ? 'تم الحذف' : 'لا يوجد'
        ],200);

    }

    public function search(Request $request){
        $group=Group::where('name','Like','%'.$request->search.'%')->get();
        if($group->count() > 0){
            return response()->json([
                'status'=> 200,
                'group'=>$group
            ],200);
        }else{
            return response()->json([
                'status'=> 404,
                'message'=>'لا يوجد'
            ],404);
        }
    }
    public function group_user(Request $request){
        $request->validate([
            'group_id' => 'required',
            'user_code' => 'required'
        ]);

        $user = User::where('code', $request->user_code)->first();

        $group = Group::where('id', $request->group_id)->first();

        if (isset($group) && isset($user)){
            $user->groups()->sync($group->id);
        }


        return response()->json([
            'status'=>200,
            'data'=> isset($user) && isset($group) ? ' User joined to group successfully ' : 'No users or groups found'
        ],200);

    }

    public function teacher_with_group($id){

        $user = User::where('id', $id)->first();
        $groups = Group::where('user_id', $id)->get();


        return response()->json([
            'status'=>200,
            'data'=> [
                'user' => $user ?? 'No users  found',
                'groups' => $groups ?? '',
                ]
            
          
        ],200);

    }


    public function specific_group(Request $request){
        $request->validate([
            // 'student_id' => 'required',
            'teacher_id' => 'required',
            'center_id' => 'required',
            'grade_id' => 'required',
        ]);
            $user = auth()->user();

        // $user = User::where('id', $request->student_id)->first();

        $group = Group::where('user_id', $request->teacher_id)
            ->where('center_id', $request->center_id)
            ->where('grade_id', $request->grade_id)
            ->first();

        if (isset($group) && isset($user)){
            // return $group ;
            $user->groups()->sync($group->id);
        }


        return response()->json([
            'status'=>200,
            'message'=> isset($user) && isset($group) ? ' User joined to group successfully ' : 'No users or groups found',
            'data'=>['group'=>isset($user) && isset($group) ? $group : null]
        ],200);

    }

      public function teacher_with_centers($id){

        $user = User::where('id', $id)->first();



        return response()->json([
            'status'=>200,
            'data'=> $user ?? 'No users  found',
            'centers'=> $user->centers ?? '',
        ],200);

    }
    
     public function teacher_centers(){

        $user =  auth()->user();



        return response()->json([
            'status'=>200,
            'data'=> $user,
            'centers'=> $user->centers ?? '',
        ],200);

    }
    
     public function teacher_with_center_code(Request $request){

        $user = User::where('code', $request->code)->first();



        return response()->json([
            'status'=>200,
            'data'=> $user ?? 'No users  found',
            'centers'=> $user->centers ?? '',
        ],200);

    }
    
      public function group_attendance_report(Request $request){

        $group = Group::where('id', $request->group_id)->with('users')->first();
        $att=[];
        foreach($group->users as $user ){
            $attend = Lessons_attendance::where('user_id',$user->id)->where('lesson_id',$request->lesson_id)->first();
            if($attend){
                $att[] =['student'=>$user,'attandance'=>1] ;
            }else{
                $att[] =['student'=>$user,'attandance'=>0] ;
            }
            
        }


        return response()->json([
            'status'=>200,
            'data'=> ['group'=>$group,'attendance'=> $att] ,
          
        ],200);

    }

}
