<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Video;
use Illuminate\Http\Request;

class videosController extends Controller
{
    
     public function index(Request $request){
        
        $request->validate([
            'teacher_id' => 'required',
        ]);
        $videos= Video::where('teacher_id',$request->teacher_id)->get();
        
        return response()->json([
            'status'=>200,
            'data'=>  ['videos'=>$videos],
        ],200);

    }
    
    public function store(Request $request){
        
        $request->validate([
            'name' => 'required',
            'url' => 'required',
            'duration' => 'required',
            'teacher_id' => 'required',
        ]);
        $video= Video::create([
             'name' => $request->name,
            'url' => $request->url,
            'duration' => $request->duration,
            'teacher_id' => $request->teacher_id,
            'unlock_code' => $request->unlock_code,
            'free' => $request->free,
            ]);
        
        return response()->json([
            'status'=>200,
            'data'=>  $video ?? 'No videos found',
        ],200);

    }
    
    
        public function delete(Request $request){
        $Exam=Video::find($request->id);
        $Exam->delete();
        if($Exam){
            return response()->json([
                'status'=>200,
                'message'=>'Video Deleted Successfully'
            ],200);
        }
    }
}
