<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\LessonsRequest;
use App\Http\Resources\LessonsResource;
use App\Models\Lesson;
use App\Models\Lessons_attendance;
use App\Models\User;
use Illuminate\Http\Request;
use Carbon\Carbon;


class LessonsController extends Controller
{
    public function index(){
        $lessons = Lesson::all();

        return response()->json([
            'status'=>$lessons->count() > 0 ? 200 : 404,
            'data'=> $lessons->count() > 0 ? $lessons : 'No lessons found'
        ],200);

    }
     public function group_lessons(Request $request){
        $lessons = Lesson::where('group_id',$request->group_id)->orderBy('id',"DESC")->get();

        return response()->json([
            'status'=> 200 ,
            'data'=> ['lessons'=>$lessons]
        ],200);

    }


    public function store(LessonsRequest $request){

        $lesson = Lesson::create($request->all());

        return response()->json([
            'status'=>200,
            'data'=>$lesson,
            'message'=>'Lesson Created Successfully'
        ],200);
    }

    public function show($id){
        $lesson = Lesson::findOrFail($id);

        return response()->json([
            'status'=>$lesson ? 200 : 404,
            'data'=> $lesson ?? 'No lessons found'
        ],200);

    }

    public function update(LessonsRequest $request){
        $lesson = Lesson::find($request->id);

        $lesson->update($request->all());
        return response()->json([
            'status'=>200,
            'data'=>$lesson,
            'message'=>'Lesson Updated Successfully'
        ],200);
    }

    public function destroy(Request $request){

        $lesson = Lesson::where('id', $request->id)->delete();

            return response()->json([
                'status'=> $lesson ? 200 : 404,
                'message'=>$lesson ? 'Lesson Deleted Successfully' : 'No lessons found'
            ],200);

    }

    public function attendance_num(Request $request){

        $user = User::where('code', $request->user_code)->first();
        $lesson = Lesson::where('id', $request->lesson_id)->first();

        if (isset($user) && isset($lesson)){
            $attendance = Lessons_attendance::create([
               'lesson_id' => $lesson->id,
               'user_id' => $user->id
            ]);
        }

            return response()->json([
                'status'=>200,
                'message'=>isset($attendance) ? 'User attended successfully' : 'No lessons or users found'
            ],200);

    }
    
    
    public function bulk_attendance(Request $request){
        foreach($request->attendance as $attend){

      
            $attendance[] = Lessons_attendance::create([
               'lesson_id' => $attend['lesson_id'],
               'user_id' => User::where("code",$attend['student_code'])->first()->id
            ]);
        }
        
            return response()->json([
                'status'=>200,
                'message'=>isset($attendance) ? 'User attended successfully' : 'No lessons or users found'
            ],200);

    }

    public function attendance_qr($id){

        $user = auth()->user();
        $lesson = Lesson::where('id', $id)->first();

        if (isset($user) && isset($lesson)){
            $attendance = Lessons_attendance::create([
               'lesson_id' => $lesson->id,
               'user_id' => $user->id
            ]);
        }

            return response()->json([
                'status'=>200,
                'message'=>isset($attendance) ? 'User attended successfully' : 'No lessons or users found'
            ],200);

    }
    public function lesson_by_date($group_id){
        $lesson = Lesson::where('group_id',$group_id)->whereDate('lesson_date', Carbon::today())->first();

        return response()->json([
            'status'=>$lesson ? 200 : 404,
            'data'=> $lesson ?? 'No lessons found'
        ],200);

    }
        public function get_attendance(Request $request){

        $user = User::where('code', $request->user_code)->first();
        $lesson = Lesson::where('id', $request->lesson_id)->first();

        if (isset($user) && isset($lesson)){
            $attendance = Lessons_attendance::create([
               'lesson_id' => $lesson->id,
               'user_id' => $user->id
            ]);
        }

            return response()->json([
                'status'=>200,
                'message'=>isset($attendance) ? 'User attended successfully' : 'No lessons or users found'
            ],200);

    }
    
       public function group_attendance(Request $request){
            $att=0;
        $user = auth()->user();
        $lessons = Lesson::where('group_id', $request->group_id)->get();
        foreach($lessons as $lesson){
        $attendance=Lessons_attendance::where('lesson_id',$lesson->id)->where('user_id',$user->id)->first();
            if($attendance){
                $att ++;
            }
        }

            return response()->json([
                'status'=>200,
                'data'=>['lessons'=>count($lessons),'attendance'=>$att]
            ],200);
}


}
