<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Helpers\Helper;
use App\Http\Requests\LoginRequest;
use App\Http\Resources\UserResource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Lesson;
use App\Models\Lessons_attendance;


class LoginController extends Controller
{//validate login user send response

    public function login(LoginRequest $request){
        if(!Auth::attempt($request->only('email','password'))){
            Helper::sendError('email or password is wrong!!!');
        }
        $user = auth()->user();
        $user->token = $user->createToken('Token')->plainTextToken;
        $groups = [];
        $attendance= [];
        foreach($user->groups as $group){
                $lessons = Lesson::where('group_id',$group->id)->get();
                foreach($lessons as $lesson){
                    $attendance[]=Lessons_attendance::where('lesson_id',$lesson->id)->where('user_id',$user->id)->first();
                }
                $count =!empty($attendance) ? count($attendance) : 0;
                
                $groups[]= [
                    "id"=> $group->id,
				"name"=> $group->name,
				"grade_id"=> $group->grade_id,
				"user_id"=> $group->user_id,
				"center_id"=> $group->center_id,
				"subject_id"=> $group->subject_id,
				"year_id"=> $group->year_id,
				"role" => $group->role,
				"created_at"=> $group->created_at,
				"updated_at"=> $group->updated_at,
				"pivot"=> [
					"user_id"=> $group->pivot->user_id,
					"group_id"=> $group->pivot->group_id ,
					"active"=> $group->pivot->active
                    ],
                    'attendance'=>$count
                
                ];
            }
        $response = [
            'data' => $user,
            
            // 'groups' => $user->groups,
            'groups' => $groups,
            'roles.permissions'=>auth()->user()->getPermissionsViaRoles()->pluck(['name']) ?? [],
            'permissions' =>auth()->user()->permissions->pluck('name') ?? [],

        ];
        return response($response);
    }
    
    public function user(Request $request) {
     auth()->user()->token = $request->token;
    $groups = [];
      foreach(auth()->user()->groups as $group){
                    $lessons = Lesson::where('group_id',$group->id)->get();
                    foreach($lessons as $lesson){
                        $attendance[]=Lessons_attendance::where('lesson_id',$lesson->id)->where('user_id',auth()->user()->id)->first();
                    }
                    $count =!empty($attendance) ? count($attendance) : 0;
                
                    $groups[]= [
                        "id"=> $group->id,
    				"name"=> $group->name,
    				"grade_id"=> $group->grade_id,
    				"user_id"=> $group->user_id,
    				"center_id"=> $group->center_id,
    				"subject_id"=> $group->subject_id,
    				"year_id"=> $group->year_id,
    				"role" => $group->role,
    				"created_at"=> $group->created_at,
    				"updated_at"=> $group->updated_at,
    				"pivot"=> [
    					"user_id"=> $group->pivot->user_id,
    					"group_id"=> $group->pivot->group_id ,
    					"active"=> $group->pivot->active
                        ],
                        'attendance'=>$count
                    
                    ];
                }
    $response = [
        'data' => auth()->user(),
        'group' => $groups,
        'roles.permissions'=>auth()->user()->getPermissionsViaRoles()->pluck(['name']) ?? [],
        'permissions' =>auth()->user()->permissions->pluck('name') ?? [],

    ];

        return response()->json($response ,200);

    }
}
