<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\QuestionRequest;
use App\Http\Resources\QuestionResource;
use App\Models\Exam;
use App\Models\Question;
use App\Models\Answer;


use Illuminate\Http\Request;

class QuestionController extends Controller
{
    public function index(request $request){
      
        $questions = Question::where('exam_id',$request->exam_id)->with('answers')->get();;
            return response()->json([
                'status'=>200,
                'data'=> ['question'=>$questions]
            ],200);
      
    }
    
      public function model_answer(request $request){
      
        $questions = Question::where('exam_id',$request->exam_id)->with('right_answers')->get();;
        if($questions->count() > 0){
            return response()->json([
                'status'=>200,
                'data'=> ['question'=>$questions]
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function store(QuestionRequest $request){
        $Question=Question::create([
            'name'=> $request->name,
            'exam_id'=>$request->exam_id,
            'grades'=>$request->grades,
           
          ]);
           if($Question){ 
               foreach(json_decode($request->answers) as $answer){
               Answer::create([
                   "name"=> $answer->name,
                   "question_id"=> $Question->id,
                   "right_answer"=> $answer->right_answer,
                   ]);
               }
               
           }
           $answers= Answer::where('question_id',$Question->id)->get();
           
           $newQuestion=  [
			[
				"id"=> $Question->id,
				"name"=> "[{\"insert\": \"Test quesion\\n\"}]",
				"exam_id"=> $Question->exam_id,
				"grades"=> $Question->grades,
				"created_at"=>$Question->created_at,
				"updated_at"=>$Question->updated_at,
				"answers"=>  $answers
			] ];
        return response()->json([
            'status'=>200,
            'data'=>[
                'question' => $newQuestion
                ] ,
            'message'=>'Question Created Successfully'
        ],200);
    }
    public function show($id){
        $Question=Question::findOrFail($id);
                   $answers= Answer::where('question_id',$Question->id)->get();

        if($Question){
            return response()->json([
                'status'=>200,
                 'data'=>[
                'question' => $Question,
                'answers'=> $answers
                ] ,
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function update(Request $request){
         $answers=[];
        foreach(($request->answers) as $answer){
            $ans=Answer::find($answer['id']);
            $ans->name =$answer['name'];
            $ans->right_answer =$answer['right_answer'];
            $ans->save();
            $answers[]=$ans;
            
        }
          $Question=Question::find($request->question_id);
            $newQuestion=  [
			[
				"id"=> $Question->id,
				"name"=> "[{\"insert\": \"Test quesion\\n\"}]",
				"exam_id"=> $Question->exam_id,
				"grades"=> $Question->grades,
				"created_at"=>$Question->created_at,
				"updated_at"=>$Question->updated_at,
				"answers"=>  $answers
			] ];
        return response()->json([
            'status'=>200,
            'data'=>$Question,
            'message'=>'Exam Updated Successfully'
        ],200);
    }
    public function delete(Request $request){
        $Question=Question::find($request->id);
        $Question->delete();
        if($Question){
            return response()->json([
                'status'=>200,
                'message'=>'Question Deleted Successfully'
            ],200);
        }
    }
    public function search($name){
        $Exam=Exam::where('season','Like','%'.$name.'%')->get();
        if($Exam->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Exam
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
}
