<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Center_user;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Lesson;
use App\Models\Lessons_attendance;

class UsersController extends Controller
{
    public function centers(){
        $users = User::role('center')->get();

        return response()->json([
            'status' => 200,
            'data' => $users ?? 'No Centers Found'
        ],200);
    }

    public function code(Request $request){

        $user = User::where('code', $request->code)->first();

        return response()->json([
            'data' => $user ?? 'No Users Found',
            'roles' => $user->roles ?? '',
            'groups' => $user->groups ?? '',
            'roles.permissions'=>auth()->user()->getPermissionsViaRoles()->pluck(['name']) ?? [],
            'permissions' =>auth()->user()->permissions->pluck('name') ?? [],
        ],200);
    }


    public function student_groups(Request $request){

        $user = User::find($request->student_id);

        return response()->json([
            'data' => $user ?? 'No Users Found',
            'roles' => $user->roles ?? '',
            'groups' => $user->groups ?? '',
            'roles.permissions'=>auth()->user()->getPermissionsViaRoles()->pluck(['name']) ?? [],
            'permissions' =>auth()->user()->permissions->pluck('name') ?? [],
        ],200);
    }
    function store_teacher_in_center(Request $request){

        $user = Center_user::create([
            'user_id' => $request->user_id,
            'center_id' => $request->center_id,
        ]);

        return response()->json([
            'status' => 200,
            'data' => $user ?? 'No Centers Found'
        ],200);
    }
    function activate_student(Request $request){
        $user = DB::table('group_user')->where('group_id',$request->group_id)->where('user_id',$request->student_id)->update(['active' => 1]);
        // $user->active =1;
        // $user->save();

        return response()->json([
            'status' => 200,
            'data' => 'Activate Successfully'
        ],200);
    }
    function deactivate_student(Request $request){

           $user = DB::table('group_user')->where('group_id',$request->group_id)->where('user_id',$request->student_id)->update(['active' => 0]);


        return response()->json([
            'status' => 200,
            'data' => 'Deactivate Successfully'
        ],200);
    }

    public function update_image(Request $request){
        $request->validate([
           'id' => 'required',
           'image' => 'required',
        ]);

        if($request->hasFile('image')){
            $file = $request->file('image');
            $filename = time() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('assets/images/users'), $filename);
            $image_name = $filename;
        }

        User::where('id', $request->id)->update([
            'image' => request()->root() . '/assets/images/users/' .$image_name
        ]);


        return response()->json([
            'status'=>200,
            'data'=> request()->root() . '/assets/images/users/' .$image_name,
            'message'=>'User Updated Successfully'
        ],200);
    }
    public function editStudent(Request $request){
        $user = auth()->user();
       User::where('id', $user->id)->update([
            'phone' => $request->phone,
            'grade' => $request->grade,
            'name' => $request->name,
            'division' => $request->division,
            
        ]);
        $user=User::find($user->id);
            foreach(auth()->user()->groups as $group){
                    $lessons = Lesson::where('group_id',$group->id)->get();
                    foreach($lessons as $lesson){
                        $attendance[]=Lessons_attendance::where('lesson_id',$lesson->id)->where('user_id',auth()->user()->id)->first();
                    }
                    $count =!empty($attendance) ? count($attendance) : 0;
                
                    $groups[]= [
                        "id"=> $group->id,
    				"name"=> $group->name,
    				"grade_id"=> $group->grade_id,
    				"user_id"=> $group->user_id,
    				"center_id"=> $group->center_id,
    				"subject_id"=> $group->subject_id,
    				"year_id"=> $group->year_id,
    				"role" => $group->role,
    				"created_at"=> $group->created_at,
    				"updated_at"=> $group->updated_at,
    				"pivot"=> [
    					"user_id"=> $group->pivot->user_id,
    					"group_id"=> $group->pivot->group_id ,
    					"active"=> $group->pivot->active
                        ],
                        'attendance'=>$count
                    
                    ];
                }
    $response = [
        'data' => auth()->user(),
        'group' => $groups,
        'roles.permissions'=>auth()->user()->getPermissionsViaRoles()->pluck(['name']) ?? [],
        'permissions' =>auth()->user()->permissions->pluck('name') ?? [],
          'message'=>'User Updated Successfully'

    ];
           return response($response);

    }


}
