<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    
    public function up(): void
    {
        Schema::create('exams_rate_users', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('exams_answers_id');
            $table->foreign('exams_answers_id')->references('id')->on('exams_answers')->onDelete('cascade');
            // $table->decimal('rate',4,2);
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams_rate_users');
    }
};
