<?php

namespace App\Http\Requests;

use App\Http\Helpers\Helper;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;

class GroupRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'name'=>'required|string',
            'grade_id'=>'required|integer',
            'user_id'=>'required|integer',
            'center_id'=>'nullable|integer',
            'subject_id'=>'required|integer',
            'year_id'=>'required|integer',
            'role'=>'required'
        ];

    }
    public function failedValidation(Validator $validator){
        Helper::sendError( 'validation error' ,$validator->errors());
    }
}
