<?php

namespace App\Http\Requests;

use App\Http\Helpers\Helper;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;

class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'name' =>'required',
            'email'=>'required|email|unique:users,email',
            'password'=>'required',
            'role'=>'required',
            'phone'=>'required',
            'parent_phone'=>'nullable',
            'class'=>'nullable',
            'subject_id'=>'nullable',
        ];
    }
    public function failedValidation(Validator $validator){
        Helper::sendError( 'validation error' ,$validator->errors());
    }
}
