<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');

            $table->date('date_of_birth')->nullable();
            $table->text('address')->nullable();
            $table->string('school')->nullable();
            $table->string('school_address')->nullable();
            $table->string('image')->nullable();
            $table->string('phone')->nullable();
            $table->string('parent_phone')->nullable();

            $table->string('qualification')->nullable();
            $table->string('specialization')->nullable();
            $table->string('class')->nullable();
            $table->string('section')->nullable();
            $table->string('branch')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
