<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Contracts\Permission as ContractsPermission;
// use  Spatie\Permission\Contracts\Role;
use  Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user_list=Permission::create(['name'=>'user_list']);
        $user_view=Permission::create(['name'=>'user_view']);
        $user_create=Permission::create(['name'=>'user_create']);
        $user_edit=Permission::create(['name'=>'user_edit']);
        $user_delete=Permission::create(['name'=>'user_delete']);

        $admin_role=Role::create(['name'=>'admin']);
        $admin_role->givePermissionTo([
            $user_list,
            $user_view,
            $user_create,
            $user_edit,
            $user_delete,
        ]);
        $admin =User::create([
            'name'=>'Admin',
            'email'=>'admin@admin.com',
            'password'=>bcrypt('password')
        ]);
        $admin->assignRole($admin_role);
        $admin->givePermissionTo([
            $user_list,
            $user_view,
            $user_create,
            $user_edit,
            $user_delete,
        ]);
        $user =User::create([
            'name'=>'user',
            'email'=>'user@user.com',
            'password'=>bcrypt('password')
        ]);
        $user_role=Role::create(['name'=>'user']);
        $user->assignRole($user_role);
        $user->givePermissionTo([
            $user_list,
        ]);
        $user_role->givePermissionTo([
            $user_list,
        ]);
    }
}
