<?php
use App\Http\Controllers\Api\{AdvertisementsController,
    ClassController,
    ExamController,
    GroupController,
    LessonsController,
    LoginController,
    quizezController,
    RegisterController,
    SubjectController,
    UsersController,
    QuestionController,
    videosController,
    MolakhsatController,
    YearsController};
use App\Http\Resources\UserResource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
    Route::post('/test_exam',[ExamController::class,'group_exam_resutls']);

Route::middleware('auth:sanctum')->get('/user',[LoginController::class,'user'] );
    Route::get('/timeNow',[YearsController::class,'timeNow']);


Route::middleware('auth:sanctum')->group( function  (){
    Route::get('/centers',[UsersController::class,'centers']);
    Route::post('/user/code',[UsersController::class,'code']);
    Route::post('/user/student_groups',[UsersController::class,'student_groups']);
    Route::post('/store_teacher_in_center',[UsersController::class,'store_teacher_in_center']);
    Route::post('/update_image',[UsersController::class,'update_image']);
    Route::post('/editStudent',[UsersController::class,'editStudent']);
    Route::post('/user/delete',[UsersController::class,'delete']);
    
    
Route::post('/preifstore',[MolakhsatController::class,'store']);
Route::post('/priefactivate',[MolakhsatController::class,'activate']);
Route::post('/priefdeactivate',[MolakhsatController::class,'deactivate']);
Route::post('/priefDelete',[MolakhsatController::class,'destroy']);

Route::post('/allpriefs',[MolakhsatController::class,'index']);
Route::post('/teacherPriefs',[MolakhsatController::class,'teacherPriefs']);
Route::post('/studentPriefs',[MolakhsatController::class,'studentPriefs']);


    // Lessons Route start
    Route::resource('/lessons',LessonsController::class);
    Route::post('/attendance_num',[LessonsController::class,'attendance_num']);
    Route::post('/group_lessons',[LessonsController::class,'group_lessons']);
    Route::post('/group_attendance',[LessonsController::class,'group_attendance']);
        Route::post('/lesson_by_date/',[LessonsController::class,'lesson_by_date']);
        Route::post('/last_group_attendance/',[LessonsController::class,'last_group_attendance']);


    Route::get('/attendance_qr/{id}',[LessonsController::class,'attendance_qr']);
    Route::post('/bulk_attendance',[LessonsController::class,'bulk_attendance']);
    Route::post('/endLesson',[LessonsController::class,'endLesson']);
// Lessons Route End

// Group Route start
    Route::get('/group',[GroupController::class,'index']);
    Route::post('/group',[GroupController::class,'store']);
    Route::get('/group/{id}',[GroupController::class,'show']);
    Route::put('/group/{id}',[GroupController::class,'update']);
    Route::post('/groupDelete',[GroupController::class,'delete']);
    Route::post('/group/search',[GroupController::class,'search']);
    Route::post('/group_user',[GroupController::class,'group_user']);
    Route::post('/specific_group',[GroupController::class,'specific_group']);
    Route::get('/teacher_with_group/{id}',[GroupController::class,'teacher_with_group']);
    Route::post('/group_attendance_report',[GroupController::class,'group_attendance_report']);
    Route::post('/teacher_groups',[GroupController::class,'teacher_groups']);

    Route::post('/add_students_group',[GroupController::class,'add_students_group']);


      Route::get('/teacher_with_group_students/{id}',[GroupController::class,'teacher_with_group']);
        Route::post('/activate_student',[UsersController::class,'activate_student']);
        Route::post('/deactivate_student',[UsersController::class,'deactivate_student']);


      Route::get('/teacher_with_center/{id}',[GroupController::class,'teacher_with_centers']);
      Route::get('/teacher_centers',[GroupController::class,'teacher_centers']);
       Route::get('/teacher_with_center_code/{code}',[GroupController::class,'teacher_with_center_code']);
//    Route::post('/find_group_add_user',[GroupController::class,'teacher_with_group']);
    Route::get('/years',[YearsController::class,'index']);
    
// Group Route End
// Exam Route start
    // Route::get('/group',[ExamController::class,'index']);
    Route::post('/exam',[ExamController::class,'store']);
    Route::post('/exam_delete',[ExamController::class,'delete']);
    Route::get('/exam/{id}',[ExamController::class,'show']);
    Route::put('/exam/{id}',[ExamController::class,'update']);
    Route::delete('/exam/{id}',[ExamController::class,'delete']);
    Route::get('/exam/search/{name}',[ExamController::class,'search']);
    Route::post('/group_exams',[ExamController::class,'index']);
    Route::post('/group_exam_resutls',[ExamController::class,'group_exam_resutls']);
    Route::post('/store_student_answer',[ExamController::class,'store_student_answer']);
    Route::post('/store_student_answer_manual',[ExamController::class,'store_student_answer_manual']);
    Route::post('/student_answer',[ExamController::class,'student_answer']);
            Route::post('/exam_questions_multi',[ExamController::class,'exam_questions']);
        Route::post('/exam_dublicate',[ExamController::class,'dublicate']);



        Route::post('/groups_exams',[ExamController::class,'groups_exams']);



    Route::post('/exam_questions',[QuestionController::class,'index']);
    Route::post('/model_answer',[QuestionController::class,'model_answer']);
    Route::post('/question',[QuestionController::class,'store']);
    Route::get('/question/{id}',[QuestionController::class,'show']);
    Route::post('/questionUpdate',[QuestionController::class,'update']);
    Route::post('/questiondelete',[QuestionController::class,'delete']);
    


// Exam Route End
// advertisement Route start
    Route::post('/group_advertisement',[AdvertisementsController::class,'index']);
    Route::post('/advertisement',[AdvertisementsController::class,'store']);
        Route::post('/student_ads',[AdvertisementsController::class,'student_ads']);


    Route::get('/advertisement/{id}',[AdvertisementsController::class,'show']);
    Route::put('/advertisement/{id}',[AdvertisementsController::class,'update']);
    Route::post('/deleteAdvertisement',[AdvertisementsController::class,'delete']);
    Route::get('/advertisement/search/{name}',[AdvertisementsController::class,'search']);
// advertisement Route end
// Subject Route start
    Route::get('/subject',[SubjectController::class,'index']);
    Route::post('/subject',[SubjectController::class,'store']);
    Route::get('/subject/{id}',[SubjectController::class,'show']);
    Route::put('/subject/{id}',[SubjectController::class,'update']);
    Route::delete('/subject/{id}',[SubjectController::class,'delete']);
    Route::get('/subject/search/{name}',[SubjectController::class,'search']);
    Route::post('/subject/users',[SubjectController::class,'subject_users']);
    Route::post('/subject/users/store',[SubjectController::class,'store_subject_users']);
// Subject Route end
// class Route start
    Route::get('/class',[ClassController::class,'index']);
    Route::post('/class',[ClassController::class,'store']);
    Route::get('/class/{id}',[ClassController::class,'show']);
    Route::put('/class/{id}',[ClassController::class,'update']);
    Route::delete('/class/{id}',[ClassController::class,'delete']);
    Route::get('/class/search/{name}',[ClassController::class,'search']);
// class Route end
// Quizez Route start
    Route::get('/quizez',[quizezController::class,'index']);
    Route::post('/quizez',[quizezController::class,'store']);
    Route::get('/quizez/{id}',[quizezController::class,'show']);
    Route::put('/quizez/{id}',[quizezController::class,'update']);
    Route::delete('/quizez/{id}',[quizezController::class,'delete']);
    Route::get('/quizez/search/{name}',[quizezController::class,'search']);
// quizez Route end
// Videos
    Route::post('/allvideos',[videosController::class,'index']);
    Route::post('/videos',[videosController::class,'store']);
    Route::post('/deleteVideo',[videosController::class,'delete']);
    Route::post('/generateCode',[videosController::class,'generateCode']);
    Route::post('/validateCode',[videosController::class,'validateCode']);
    Route::post('/VideoCodes',[videosController::class,'VideoCodes']);
    Route::post('/UserVideos',[videosController::class,'UserVideos']);
    Route::post('/VidoeViews',[videosController::class,'VidoeViews']);
    // Route::get('/quizez/{id}',[videosController::class,'show']);
    // Route::put('/quizez/{id}',[videosController::class,'update']);
    // Route::delete('/quizez/{id}',[videosController::class,'delete']);
    // Route::get('/quizez/search/{name}',[videosController::class,'search']);
});



// login And Register  Route start
Route::post('login',[LoginController::class,'login']);
Route::post('register',[RegisterController::class,'register']);
// login And Register  Route End
